# Panduan Deployment La Chroma App ke cPanel

## Masalah yang Sering Terjadi (Error 503)

Error 503 biasanya terjadi karena:
1. Port tidak dikonfigurasi dengan benar
2. Environment variables tidak di-set
3. Node.js version tidak sesuai
4. Dependencies tidak terinstall
5. Path/entry point salah

## Langkah-langkah Deployment

### 1. Upload Files ke cPanel

Upload semua file ke folder `public_html` atau subdomain folder di cPanel:
- `dist/` folder (berisi semua file build)
- `package.json`
- `package-lock.json`
- `app.json` (file konfigurasi untuk cPanel)
- `.htaccess` (untuk routing)

### 2. Install Dependencies

Masuk ke **Terminal** di cPanel atau gunakan **SSH**, lalu jalankan:

```bash
cd ~/public_html  # atau path ke folder aplikasi Anda
npm install --production
```

**PENTING**: Pastikan install dengan `--production` untuk menghindari install devDependencies yang tidak diperlukan.

### 3. Setup Node.js App di cPanel

1. Buka **cPanel** → **Setup Node.js App**
2. Klik **Create Application**
3. Isi konfigurasi:
   - **Node.js version**: Pilih versi yang sesuai (minimal Node.js 18+)
   - **Application mode**: Production
   - **Application root**: `public_html` (atau folder aplikasi Anda)
   - **Application URL**: Pilih domain/subdomain
   - **Application startup file**: `dist/index.cjs`
   - **Application Entry Point**: `dist/index.cjs`

### 4. Environment Variables

Di halaman **Setup Node.js App**, klik **Edit** pada aplikasi Anda, lalu tambahkan environment variables:

```
NODE_ENV=production
PORT=3000
```

**PENTING**: cPanel biasanya otomatis menyediakan `PORT` via environment variable. Pastikan aplikasi menggunakan `process.env.PORT` atau `process.env.PORT || 3000`.

### 5. Restart Application

Setelah setup, klik **Restart** pada aplikasi Node.js Anda.

### 6. Cek Logs

Jika masih error, cek logs:
- **Error logs**: `logs/err.log`
- **Output logs**: `logs/out.log`
- Atau di cPanel: **Setup Node.js App** → **View Logs**

## Troubleshooting

### Error 503 Service Unavailable

1. **Cek apakah aplikasi berjalan**:
   ```bash
   # Di Terminal cPanel
   ps aux | grep node
   ```

2. **Cek port yang digunakan**:
   - Pastikan aplikasi menggunakan `process.env.PORT` yang disediakan cPanel
   - Jangan hardcode port seperti `3000` atau `8080`

3. **Cek dependencies**:
   ```bash
   npm install --production
   ```

4. **Cek Node.js version**:
   - Pastikan versi Node.js sesuai (minimal 18+)
   - Cek di cPanel: **Setup Node.js App** → **Edit** → **Node.js version**

5. **Cek file permissions**:
   ```bash
   chmod 755 dist/index.cjs
   chmod -R 755 dist/
   ```

### Error: Cannot find module

1. Pastikan semua dependencies terinstall:
   ```bash
   npm install --production
   ```

2. Pastikan `node_modules` folder ada dan lengkap

### Error: Port already in use

1. Hentikan aplikasi yang berjalan
2. Restart aplikasi dari cPanel
3. Pastikan tidak ada aplikasi lain yang menggunakan port yang sama

## Struktur Folder yang Benar

```
public_html/
├── dist/
│   ├── index.cjs          # Entry point aplikasi
│   └── public/
│       ├── index.html
│       ├── assets/
│       └── favicon.png
├── package.json
├── package-lock.json
├── app.json               # Konfigurasi cPanel
├── .htaccess              # Routing rules
└── node_modules/          # Dependencies (akan dibuat setelah npm install)
```

## Catatan Penting

1. **Port**: cPanel akan otomatis assign port. Jangan hardcode port di aplikasi.
2. **Environment Variables**: Set semua env vars yang diperlukan di cPanel Node.js App settings.
3. **Database**: Jika menggunakan database, pastikan connection string sudah benar.
4. **Static Files**: File static sudah ada di `dist/public/`, pastikan server serve dengan benar.

## Testing Lokal Sebelum Deploy

Sebelum deploy, test dulu di local:

```bash
npm install --production
NODE_ENV=production PORT=3000 node dist/index.cjs
```

Jika berjalan di local, seharusnya juga berjalan di cPanel.

