# ✅ Deployment Checklist - La Chroma App

Ikuti checklist ini step by step untuk menghindari error 503.

## 📋 Pre-Deployment

- [ ] Semua file sudah di-build (`dist/` folder ada dan lengkap)
- [ ] File `app.json` sudah dibuat
- [ ] File `start.js` sudah dibuat
- [ ] File `.htaccess` sudah dibuat

## 📤 Upload ke cPanel

- [ ] Upload semua file ke folder aplikasi (biasanya `public_html` atau subdomain folder)
- [ ] Pastikan struktur folder benar:
  ```
  public_html/
  ├── dist/
  ├── package.json
  ├── package-lock.json
  ├── app.json
  ├── start.js
  └── .htaccess
  ```

## 🔧 Setup di cPanel

### 1. Setup Node.js App DULU ⚠️ PENTING!
**Setup Node.js App HARUS dilakukan dulu sebelum install dependencies!**
- [ ] Buka **cPanel** → **Setup Node.js App**
- [ ] Klik **Create Application**
- [ ] Isi konfigurasi:
  - [ ] **Node.js version**: Pilih 18 atau lebih tinggi
  - [ ] **Application mode**: Production
  - [ ] **Application root**: `public_html` (atau folder aplikasi Anda)
  - [ ] **Application URL**: Pilih domain/subdomain yang benar
  - [ ] **Application startup file**: `start.js` ⚠️ **PENTING!**
  - [ ] **Load App File**: `app.json`
- [ ] Klik **Create**

### 2. Install Dependencies
**Sekarang npm sudah tersedia setelah setup Node.js App**
- [ ] Buka Terminal di cPanel atau gunakan SSH
- [ ] Masuk ke folder aplikasi: `cd ~/public_html`
- [ ] Install dependencies: `npm install --production`
- [ ] Pastikan tidak ada error saat install
- [ ] **Jika masih error "npm: command not found"**, baca `FIX_NPM_NOT_FOUND.md`

### 3. Environment Variables
- [ ] Di halaman edit aplikasi, tambahkan environment variables:
  - [ ] `NODE_ENV=production`
  - [ ] (Jangan set PORT manual, cPanel akan otomatis set)

### 4. Restart Application
- [ ] Klik **Restart** pada aplikasi Node.js
- [ ] Tunggu beberapa detik
- [ ] Cek status aplikasi (harus "Running")

## 🧪 Testing

- [ ] Buka URL aplikasi di browser
- [ ] Pastikan tidak ada error 503
- [ ] Cek apakah halaman load dengan benar
- [ ] Test beberapa halaman/fitur

## 🔍 Jika Masih Error 503

### Cek Logs
- [ ] Buka **Setup Node.js App** → Pilih aplikasi → **View Logs**
- [ ] Cek error logs untuk detail error
- [ ] Screenshot error jika perlu

### Common Fixes
- [ ] Pastikan `start.js` sebagai startup file (BUKAN `dist/index.cjs`)
- [ ] Pastikan dependencies sudah terinstall: `npm install --production`
- [ ] Pastikan Node.js version minimal 18+
- [ ] Pastikan `NODE_ENV=production` sudah di-set
- [ ] Coba restart aplikasi lagi
- [ ] Cek apakah port tidak conflict dengan aplikasi lain

### Cek File Permissions
Di Terminal:
```bash
chmod 755 start.js
chmod 755 dist/index.cjs
chmod -R 755 dist/
```

## ✅ Final Check

- [ ] Aplikasi status: **Running**
- [ ] Tidak ada error 503
- [ ] Website bisa diakses
- [ ] Semua fitur berfungsi dengan benar

## 📝 Catatan

- **PORT**: Jangan set manual, cPanel akan otomatis assign
- **Startup File**: Harus `start.js`, bukan `dist/index.cjs`
- **Dependencies**: Install dengan `--production` flag
- **Logs**: Selalu cek logs jika ada masalah

---

**Jika semua checklist sudah dicentang tapi masih error, cek logs dan hubungi support hosting Anda.**

