# 🔧 Fix: npm command not found di cPanel

## Masalah
Saat menjalankan `npm install --production` di terminal cPanel, muncul error:
```
bash: npm: command not found
```

## Solusi

### ✅ Solusi 1: Aktifkan Node.js di cPanel (RECOMMENDED)

1. **Buka cPanel** → **Setup Node.js App**
2. **Buat aplikasi dulu** (walaupun belum install dependencies):
   - Klik **Create Application**
   - Isi konfigurasi:
     - **Node.js version**: Pilih versi yang tersedia (minimal 18+)
     - **Application root**: `public_html` (atau folder aplikasi Anda)
     - **Application URL**: Pilih domain/subdomain
     - **Application startup file**: `start.js`
     - **Load App File**: `app.json`
   - Klik **Create**
3. **Setelah aplikasi dibuat**, npm akan otomatis tersedia di terminal
4. **Sekarang jalankan lagi**:
   ```bash
   cd ~/public_html
   npm install --production
   ```

### ✅ Solusi 2: Load Node.js Environment Manual

Di terminal cPanel, jalankan perintah ini **SEBELUM** `npm install`:

```bash
# Load Node.js environment
source ~/.bashrc
# atau
export PATH=$PATH:/opt/cpanel/ea-nodejs18/bin  # Ganti 18 dengan versi Node.js Anda
```

Kemudian jalankan:
```bash
npm install --production
```

### ✅ Solusi 3: Gunakan Full Path ke npm

Cari lokasi npm di server:
```bash
which node
which npm
# atau
find /opt/cpanel -name npm 2>/dev/null
```

Setelah ketemu, gunakan full path:
```bash
/opt/cpanel/ea-nodejs18/bin/npm install --production
# Ganti 18 dengan versi Node.js yang tersedia
```

### ✅ Solusi 4: Install via cPanel Node.js App Manager

1. **Buka cPanel** → **Setup Node.js App**
2. **Buat aplikasi** (seperti di Solusi 1)
3. Setelah aplikasi dibuat, di halaman aplikasi ada opsi untuk **install dependencies**
4. Klik **NPM Install** atau **Install Dependencies** (jika tersedia)

## ⚠️ Urutan yang Benar

**JANGAN** install dependencies dulu sebelum setup Node.js App di cPanel!

**Urutan yang benar:**
1. ✅ Upload semua file ke cPanel
2. ✅ **Setup Node.js App di cPanel dulu** (ini akan mengaktifkan npm)
3. ✅ Baru install dependencies: `npm install --production`
4. ✅ Set environment variables
5. ✅ Restart aplikasi

## 🎯 Langkah Lengkap (Step by Step)

### Step 1: Upload Files
Upload semua file ke `public_html` atau folder aplikasi Anda.

### Step 2: Setup Node.js App di cPanel
1. Buka **cPanel** → **Setup Node.js App**
2. Klik **Create Application**
3. Isi:
   - **Node.js version**: Pilih yang tersedia (18+)
   - **Application root**: `public_html`
   - **Application URL**: Pilih domain/subdomain
   - **Application startup file**: `start.js`
   - **Load App File**: `app.json`
4. Klik **Create**

### Step 3: Install Dependencies
Sekarang npm sudah tersedia, jalankan:
```bash
cd ~/public_html
npm install --production
```

### Step 4: Set Environment Variables
Di halaman edit aplikasi Node.js:
- Tambahkan: `NODE_ENV=production`
- (PORT akan otomatis di-set oleh cPanel)

### Step 5: Restart
Klik **Restart** pada aplikasi Node.js Anda.

## 🔍 Verifikasi

Setelah setup Node.js App, verifikasi npm tersedia:
```bash
which npm
node --version
npm --version
```

Jika masih error, coba:
```bash
source ~/.bashrc
which npm
```

## 📝 Catatan Penting

- **Setup Node.js App HARUS dilakukan dulu** sebelum bisa menggunakan npm di terminal
- Setelah setup Node.js App, npm akan otomatis tersedia
- Jika masih tidak bisa, coba logout dan login lagi ke terminal
- Beberapa hosting memerlukan waktu beberapa menit untuk mengaktifkan npm setelah setup

## 🆘 Masih Error?

Jika masih tidak bisa setelah setup Node.js App:
1. Coba logout dan login lagi ke terminal cPanel
2. Cek apakah Node.js App sudah dibuat dengan benar
3. Hubungi support hosting Anda untuk mengaktifkan npm
4. Atau gunakan Solusi 3 (full path ke npm)

---

**Intinya: Setup Node.js App di cPanel DULU, baru install dependencies!** ✅

