# 🚀 La Chroma App - Deployment Guide

## 📁 File yang Sudah Dibuat untuk Deployment

Saya sudah membuat file-file berikut untuk membantu deployment ke cPanel:

### ✅ File Konfigurasi
1. **`app.json`** - Konfigurasi untuk cPanel Node.js App
2. **`start.js`** - Startup script yang memastikan port dan environment benar
3. **`.htaccess`** - Routing rules untuk Apache (jika diperlukan)

### ✅ Dokumentasi
1. **`QUICK_START.md`** - Panduan cepat 5 menit
2. **`DEPLOYMENT.md`** - Panduan lengkap dengan troubleshooting
3. **`DEPLOYMENT_CHECKLIST.md`** - Checklist step-by-step
4. **`FIX_NPM_NOT_FOUND.md`** - Solusi untuk error "npm: command not found"

## 🎯 Solusi Error 503

Error 503 biasanya terjadi karena:

1. ❌ **Port tidak dikonfigurasi dengan benar**
   - ✅ **Solusi**: Gunakan `start.js` sebagai startup file (bukan `dist/index.cjs`)
   - ✅ cPanel akan otomatis set PORT via environment variable

2. ❌ **Dependencies tidak terinstall**
   - ✅ **Solusi**: Jalankan `npm install --production` di cPanel Terminal

3. ❌ **Node.js version tidak sesuai**
   - ✅ **Solusi**: Gunakan Node.js 18 atau lebih tinggi

4. ❌ **Startup file salah**
   - ✅ **Solusi**: Di cPanel, set startup file ke `start.js`

5. ❌ **Environment variables tidak di-set**
   - ✅ **Solusi**: Set `NODE_ENV=production` di cPanel Node.js App settings

## 📝 Langkah Cepat

### 1. Upload Files
Upload semua file ke folder aplikasi di cPanel (biasanya `public_html`)

### 2. Setup Node.js App di cPanel DULU ⚠️
**PENTING**: Setup Node.js App dulu sebelum install dependencies!
1. Buka **cPanel** → **Setup Node.js App** → **Create Application**
2. Set startup file: `start.js`
3. Load App File: `app.json`
4. Klik **Create**

### 3. Install Dependencies
**Sekarang npm sudah tersedia**, jalankan:
```bash
cd ~/public_html
npm install --production
```

**Jika error "npm: command not found"**, baca `FIX_NPM_NOT_FOUND.md`

### 4. Setup Environment & Restart
1. Di halaman edit aplikasi Node.js (yang sudah dibuat di step 2)
2. Add environment variable: `NODE_ENV=production`
3. Klik **Restart**

### 5. Test
Buka URL aplikasi Anda di browser.

## 🔍 Troubleshooting

### Error: "npm: command not found"
**Ini masalah paling umum!** Baca file `FIX_NPM_NOT_FOUND.md` untuk solusi lengkap.

**Quick fix**: Setup Node.js App di cPanel DULU, baru install dependencies.

### Error 503
Jika masih error 503:

1. **Cek Logs**: Di cPanel → Setup Node.js App → View Logs
2. **Pastikan startup file**: Harus `start.js`, bukan `dist/index.cjs`
3. **Pastikan dependencies**: Jalankan `npm install --production` lagi
4. **Restart aplikasi**: Klik Restart di cPanel

## 📚 Dokumentasi Lengkap

- **Quick Start**: Baca `QUICK_START.md` untuk panduan cepat
- **Full Guide**: Baca `DEPLOYMENT.md` untuk panduan lengkap
- **Checklist**: Ikuti `DEPLOYMENT_CHECKLIST.md` step by step

## ⚠️ Poin Penting

1. **Startup File**: Harus `start.js` (bukan `dist/index.cjs`)
2. **PORT**: Jangan set manual, cPanel akan otomatis set
3. **Dependencies**: Install dengan `--production` flag
4. **Node.js Version**: Minimal 18+

## 🆘 Butuh Bantuan?

Jika masih error setelah mengikuti semua langkah:
1. Screenshot error message
2. Cek dan screenshot logs dari cPanel
3. Pastikan semua checklist di `DEPLOYMENT_CHECKLIST.md` sudah dicentang

---

**Good luck dengan deployment! 🎉**

